;  "Bally Pin"
;  AKA "Astrocade Pinball"
;  for the Bally Arcade/Astrocade
;  
;  Version .04 
;
;  Videocade #3005
;  Bally Pin
;  Programmed by Bob Ogdon
;  Audio by Scot Norris
;
;  Disassembly Started June 11, 2018 by Adam Trionfo
;
;  This program can be assembled using ZMAC.  Make sure that HVGLIB.H
;  is in the same directory and then type:
;      zmac -i -m -o pinhack.bin -x pinhack.lst pinhack.asm
;
;  Version History:
;    .04 (Jun. 20, 2018) - Disassembled more of the ROM.
;                        - Disassembled BMUSIC scores
;    .03 (Jun. 19, 2018) - Disassembled MUCH more of the ROM.
;                        - Disassembled the DOIT Table and the
;                          many routines that are called from it.
;                        - Found some graphic patterns.
;    .02 (Jun. 12, 2018) - Added Review and instructions to end
;                          of source code.
;                        - Disassembled a little more code and a
;                          small amount of graphics. 
;    .01 (Jun. 11, 2018) - First Distributed version.
;                          Distributed at BallyAlley.com
;
;  The idea to hack the tables in Bally Pin led to this
;  disassembly of the game.  Only about 2 1/2 hours were spent on
;  this disassembly.  It's really just an example of how quickly
;  progress can be made using some of the tools available on
;  BallyAlley.com.
;
;  The tools used to disassemble the Bally Pin binary image to 
;  Z80 source code are:
;  
;     1) Z80 2.0 - A Z80 Disassembler
;     2) DZ80 Dissassembler Script - Required to disassemble
;                                    Astrocade ROM routines.
;     3) HVGLIB.H - Home Video Game Library Equates.
;          
;  These disassembly tools are available here:
;
;     http://www.ballyalley.com/ml/ml_tools/ml_tools.html
;
;  This source code assembles to a byte-for-byte identical ROM
;  image of Bally Pin.
; 
;  These are many, MANY more areas of the code that are called
;  or jumped-to in the already disassembled part of the game.
;  Without much effort, I suppose much of this game can be
;  disassembled.  The trick is following the code and understanding
;  what is going on that is time consuming.  From my brief look
;  at the code so far, it seems that the tables are drawn
;  with recantagles.
;
;  If anyone decides to continue to disassemble this code, then
;  please let me know.  I'd like to put any additional efforts
;  online at BallyAlley.com.
;
;  Column Breaks - 80 column references used for printer settings for
;                  assembly listings.
;
;        1         2         3         4         5         6         7         8
;  45678901234567890123456789012345678901234567890123456789012345678901234567890

        INCLUDE "HVGLIB.H"      ; Home Video Game Library

NUMPLA  EQU     $4FF3           ; Number of Players

        ORG     FIRSTC

        DB      'U'             ; Sentinal for Menu Start

;  First Menu Item node
        DW      L2016           ; ... Next Menu Node
        DW      L2F1F           ; ... Choice 1 Text is "BALLY PIN 1"
        DW      L2107           ; ... Start of "Bally Pin 1" 

;  Reset Vector Jumps - Used with RST Instruction      
        JP      L2A3A            ; Reset VECTor #1 /  8 / $08
        JP      L2A67            ; Reset VECTor #2 / 16 / $10
        JP      L2A55            ; Reset VECTor #3 / 24 / $18
        JP      L2A90            ; Reset VECTor #4 / 32 / $20
        JP      L2A79            ; Reset VECTor #5 / 40 / $28

;  Second Menu Item node
L2016:  DW      MENUST          ; ... Next Menu Node
        DW      L2F2B           ; ... Choice 1 Text is "BALLY PIN 2"
        DW      L2169           ; ... Start of "Bally Pin 2" 

;  Screen INTerrupt VECtor
L201C:  DW      L2255

L201E:  LD      A,$BC            ;  ... VERBL*2 = 188
        OUT     (VERBL),A        ; write VERtical Blanking Line
        
;  Get Number of Players
L2022:  SYSSUK  GETPAR           ;  UPI GET game PARameter from user
        DW      $0228            ;  ... "Number Of PLAYers" string
        DB      $01              ;  ... Digits = 1
        DW      NUMPLA           ;  ... Parameter Address = $4FF3
        ;
        LD      A,(HL)
        OR      A
        JR      Z,L2022
        LD      A,$04
        CP      (HL)
        JR      C,L2022
        DI      
        POP     DE
        LD      HL,$4F0B
        LD      SP,HL
        PUSH    DE
        
;  Set-up Interrupt Vector for $201C
        LD      HL,L201C
        LD      A,H              
        LD      I,A              ; High byte of Interrupt Vector
        LD      A,L
        OUT     (INFBK),A        ; Port $D, write INterrupt FeedBacK
        IM      2
        SYSTEM  INTPC            ;  UPI INTerPret with Context create
        ;
        DO      COLSET           ;  UPI COLors SET
        DW      L2EF9            ;  ... Table Address = 12025
        ;
        DO      SETOUT           ;  UPI SET some OUTput ports
        DB      $BA              ;  ... VERBL*2 = 186
        DB      $AD              ;  ... HORCB/4 = 173
        DB      $08              ;  ... INMOD = 8
        ;
        DO      FILL             ;  UPI FILL memory with data
        DW      $4000            ;  ... Memory Address = 16384
        DW      $0ED8            ;  ... Byte Count = 3800
        DB      $00              ;  ... Data = 0
        ;
        DO      FILL             ;  UPI FILL memory with data
        DW      $4F0B            ;  ... Memory Address = 20235
        DW      $00C2            ;  ... Byte Count = 194
        DB      $00              ;  ... Data = 0
        ;
        DO      FILL             ;  UPI FILL memory with data
        DW      $4FD5            ;  ... Memory Address = 20437
        DW      $000A            ;  ... Byte Count = 10
        DB      $00              ;  ... Data = 0
        ;
        DONT    XINTC            ;  UPI eXit INTerpreter with Context
        ;
        LD      IX,$4F17
        LD      HL,$4F8A
        SET     4,(HL)
        LD      A,$AA
        LD      ($4F8C),A
        LD      HL,$4FAA
        LD      (HL),$05
        INC     HL
        LD      (HL),$05
        LD      H,$AA
        LD      C,$0B
        LD      DE,$4931
        RST     $08              ;  User ReStarT #1 of 6
        LD      C,$0B
        LD      DE,$496E
        RST     $08              ;  User ReStarT #1 of 6
        LD      C,$0D
        LD      DE,$543A
        RST     $18              ;  User ReStarT #3 of 6
        LD      C,$0D
        LD      DE,$5465
        RST     $28              ;  User ReStarT #5 of 6
        SYSTEM  INTPC            ;  UPI INTerPret with Context create
        ;
        DO      RECTAN           ;  UPI paint a RECTANgle
        DB      $27              ;  ... X = 39
        DB      $4A              ;  ... Y = 74
        DB      $15              ;  ... Width = 21
        DB      $10              ;  ... Height = 16
        DB      $AA              ;  ... Color = 170
        ;
        DO      RECTAN           ;  UPI paint a RECTANgle
        DB      $64              ;  ... X = 100
        DB      $4A              ;  ... Y = 74
        DB      $15              ;  ... Width = 21
        DB      $10              ;  ... Height = 16
        DB      $AA              ;  ... Color = 170
        ;
        DO      RECTAN           ;  UPI paint a RECTANgle
        DB      $00              ;  ... X = 0
        DB      $44              ;  ... Y = 68
        DB      $1C              ;  ... Width = 28
        DB      $1B              ;  ... Height = 27
        DB      $AA              ;  ... Color = 170
        ;
        DO      RECTAN           ;  UPI paint a RECTANgle
        DB      $27              ;  ... X = 39
        DB      $54              ;  ... Y = 84
        DB      $1F              ;  ... Width = 31
        DB      $0B              ;  ... Height = 11
        DB      $AA              ;  ... Color = 170
        ;
        DO      RECTAN           ;  UPI paint a RECTANgle
        DB      $5A              ;  ... X = 90
        DB      $54              ;  ... Y = 84
        DB      $1F              ;  ... Width = 31
        DB      $0B              ;  ... Height = 11
        DB      $AA              ;  ... Color = 170
        ;
        DO      RECTAN           ;  UPI paint a RECTANgle
        DB      $84              ;  ... X = 132
        DB      $44              ;  ... Y = 68
        DB      $1C              ;  ... Width = 28
        DB      $1B              ;  ... Height = 27
        DB      $AA              ;  ... Color = 170
        ;
        DO      RECTAN           ;  UPI paint a RECTANgle
        DB      $00              ;  ... X = 0
        DB      $00              ;  ... Y = 0
        DB      $A0              ;  ... Width = 160
        DB      $02              ;  ... Height = 2
        DB      $AA              ;  ... Color = 170
        ;
        DO      RECTAN           ;  UPI paint a RECTANgle
        DB      $00              ;  ... X = 0
        DB      $00              ;  ... Y = 0
        DB      $03              ;  ... Width = 3
        DB      $44              ;  ... Height = 68
        DB      $AA              ;  ... Color = 170
        ;
        DO      RECTAN           ;  UPI paint a RECTANgle
        DB      $9D              ;  ... X = 157
        DB      $00              ;  ... Y = 0
        DB      $03              ;  ... Width = 3
        DB      $44              ;  ... Height = 68
        DB      $AA              ;  ... Color = 170
        ;
        DONT    XINTC            ;  UPI eXit INTerpreter with Context
        ;
        PUSH    IX
        LD      A,($4FF3)
        LD      B,A
        LD      C,$31
        LD      IX,$020D
        LD      HL,$2EF5
L20D8:  LD      E,(HL)
        INC     HL
        PUSH    HL
        PUSH    BC
        LD      D,$56
        LD      BC,$0715
        XOR     A
        SYSTEM  RECTAN           ;  UPI paint a RECTANgle
        ;
        INC     E
        INC     D
        LD      BC,$C528
        LD      HL,$4FBD
        SYSTEM  DISNUM           ;  UPI DISplay NUMber
        ;
        LD      A,E
        SBC     A,$0D
        LD      E,A
        LD      D,$4E
        POP     BC
        LD      A,C
        INC     C
        PUSH    BC
        LD      C,$2C
        SYSTEM  CHRDIS           ;  UPI CHaRacter DISplay
        ;
        POP     BC
        POP     HL
        DJNZ    L20D8
        POP     IX
        SET     0,(IX+$01)
        RET     

L2107:  CALL    L201E  

L210A:  LD      H,$AA
        LD      C,$0C
        LD      DE,$0102
        RST     $10              ;  User ReStarT #2 of 6
        LD      C,$10
        LD      DE,$0148
        RST     $20              ;  User ReStarT #4 of 6
        LD      C,$10
        LD      DE,$019D
        RST     $20              ;  User ReStarT #4 of 6
        LD      C,$0A
        LD      DE,$1A0D
        RST     $18              ;  User ReStarT #3 of 6
        LD      C,$08
        LD      DE,$1F14
        RST     $08              ;  User ReStarT #1 of 6
        LD      C,$08
        LD      DE,$1D87
        RST     $08              ;  User ReStarT #1 of 6
        LD      C,$1B
        LD      DE,$4402
        RST     $18              ;  User ReStarT #3 of 6
        LD      C,$1B
        LD      DE,$449D
        RST     $28              ;  User ReStarT #5 of 6
        LD      C,$10
        LD      DE,$0148
        RST     $10              ;  User ReStarT #2 of 6
        SYSSUK  RECTAN           ;  UPI paint a RECTANgle
        DB      $0D              ;  ... X = 13
        DB      $1B              ;  ... Y = 27
        DB      $07              ;  ... Width = 7
        DB      $06              ;  ... Height = 6
        DB      $AA              ;  ... Color = 170
       ;
        LD      HL,$1F14
        LD      ($4FA8),HL
        LD      BC,$0228
        LD      HL,$2F0F
        CALL    L2DBC
        LD      BC,$0268
        LD      HL,$2F0B
        CALL    L2DBC
        LD      HL,$2E58
        LD      DE,$1404
        JR      L21C4

L2169:  CALL    L201E  

L216C:  SYSSUK  COLSET           ;  UPI COLors SET
        DW      L2EFD            ;  ... Table Address = 12029
        ;
        SET     3,(IX+$01)
        LD      H,$AA
        LD      C,$10
        LD      DE,$0102
        RST     $10              ;  User ReStarT #2 of 6
        LD      C,$0E
        LD      DE,$0133
        RST     $20              ;  User ReStarT #4 of 6
        LD      C,$0E
        LD      DE,$016C
        RST     $20              ;  User ReStarT #4 of 6
        LD      C,$10
        LD      DE,$019D
        RST     $20              ;  User ReStarT #4 of 6
        LD      C,$08
        LD      DE,$1D87
        RST     $08              ;  User ReStarT #1 of 6
        LD      C,$1B
        LD      DE,$4402
        RST     $18              ;  User ReStarT #3 of 6
        LD      C,$1B
        LD      DE,$449D
        RST     $28              ;  User ReStarT #5 of 6
        LD      C,$0E
        LD      DE,$0133
        RST     $10              ;  User ReStarT #2 of 6
        LD      C,$0E
        LD      DE,$016C
        RST     $10              ;  User ReStarT #2 of 6
        LD      BC,$0328
        LD      HL,$2F19
        CALL    L2DBC
        LD      BC,$0368
        LD      HL,$2F13
        CALL    L2DBC
        LD      HL,$2EA0
        LD      DE,$1800
L21C4:  PUSH    DE
        LD      DE,$4F26
        LD      BC,$004B
        LDIR    
        POP     DE
        LD      B,$04
        LD      HL,$4F71
        LD      A,$FF
L21D5:  LD      (HL),$01
        INC     HL
        LD      (HL),A
        INC     HL
        LD      (HL),A
        INC     HL
        LD      (HL),A
        INC     HL
        LD      (HL),D
        INC     HL
        LD      (HL),E
        INC     HL
        DJNZ    L21D5
        LD      A,$06
        LD      ($4F8E),A
        LD      ($4F94),A
        LD      ($4FA0),A
        LD      ($4FA6),A
        LD      ($4F9A),A
        CALL    L2CC4
        SYSSUK  RECTAN           ;  UPI paint a RECTANgle
        DB      $1C              ;  ... X = 28
        DB      $44              ;  ... Y = 68
        DB      $01              ;  ... Width = 1
        DB      $01              ;  ... Height = 1
        DB      $00              ;  ... Color = 0
        
        SYSSUK  RECTAN           ;  UPI paint a RECTANgle
        DB      $83              ;  ... X = 131
        DB      $44              ;  ... Y = 68
        DB      $01              ;  ... Width = 1
        DB      $01              ;  ... Height = 1
        DB      $00              ;  ... Color = 0
        
        SYSSUK  RECTAN           ;  UPI paint a RECTANgle
        DB      $46              ;  ... X = 70
        DB      $54              ;  ... Y = 84
        DB      $01              ;  ... Width = 1
        DB      $01              ;  ... Height = 1
        DB      $00              ;  ... Color = 0
        ;
        SYSSUK  RECTAN           ;  UPI paint a RECTANgle
        DB      $59              ;  ... X = 89
        DB      $54              ;  ... Y = 84
        DB      $01              ;  ... Width = 1
        DB      $01              ;  ... Height = 1
        DB      $00              ;  ... Color = 0
        ;
        LD      C,$28
        LD      B,$02
L2218:  LD      A,$CC
        OUT     ($19),A
        LD      A,C              ;  ... Magic Register
        LD      HL,L2E4D         ;  ... Pattern Address - 
        LD      DE,$441C         ;  ... D = Y Coordinate, E = X Coordinate  
        SYSTEM  WRITR            ;  UPI WRITe RELATIVE
        ;
        LD      A,C
        LD      DE,$5446
        SYSTEM  WRITR            ;  UPI WRITe RELATIVE
        ;
        LD      C,$68
        DJNZ    L2218
        SYSSUK  RECTAN           ;  UPI paint a RECTANgle
        DB      $07              ;  ... X = 7
        DB      $3A              ;  ... Y = 58
        DB      $07              ;  ... Width = 7
        DB      $07              ;  ... Height = 7
        DB      $00              ;  ... Color = 0
        ;
        LD      A,$05
        LD      ($4FCC),A
        CALL    L2BD8
        LD      HL,$1D87
        LD      ($4FAE),HL
        LD      A,$30
        LD      ($4FD9),A
L2249:  DI      
        SYSSUK  SENTRY           ;  UPI SENse TRansition
        DW      $0214            ;  ... Keymask Address = 532
        ;
        EI      
        SYSSUK  DOIT             ;  UPI DOIT table, branch to translation handler
        DW      L2F3B            ;  ... Table Address = 12091
        ;
        JR      L2249

;  Screen Interrupt Routine
L2255:  PUSH    AF
        PUSH    BC
        PUSH    DE
        PUSH    HL
        PUSH    IX
        LD      IX,$4F17
        LD      A,$60
        LD      HL,$4F8C
        RLC     (HL)
        JR      C,L226A
        LD      A,$C0
L226A:  OUT     ($0F),A
        BIT     7,(HL)
        JP      NC,L232C
        CALL    STIMER           ; Seconds and game TIMER, music
        LD      HL,$4F8A
        BIT     2,(HL)
        JR      Z,L22B6
        PUSH    HL
        LD      HL,$4FC9
        INC     (HL)
        LD      A,(HL)
        LD      DE,($4FC7)
        LD      BC,$0016
        BIT     7,D
        JR      Z,L228F
        LD      BC,$FFEA
L228F:  LD      HL,($4F1F)
        ADD     HL,BC
        LD      ($4F1F),HL
        LD      HL,($4FC5)
        LD      BC,$0101
        SYSTEM  SCROLL           ;  UPI SCROLL area of screen
        ;
        CALL    L2AAA
        ADD     HL,DE
        LD      ($4FC5),HL
        CP      $15
        JR      NZ,L22B5
        XOR     A
        LD      ($4FC9),A
        ADD     HL,DE
        LD      ($4FC5),HL
        LD      ($4FC7),DE
L22B5:  POP     HL
L22B6:  BIT     4,(HL)
        JR      NZ,L230F
        PUSH    HL
        IN      A,($10)
        LD      HL,$4FA1
        AND     $10
        CP      (HL)
        JR      Z,L22C9
        LD      (HL),A
        POP     HL
        JR      L22D1
L22C9:  POP     HL
        AND     A
        SET     6,(HL)
        JR      NZ,L22D1
        RES     6,(HL)
L22D1:  PUSH    HL
        IN      A,($11)
        LD      HL,$4FB0
        AND     $10
        CP      (HL)
        JR      Z,L22E0
        LD      (HL),A
        POP     HL
        JR      L22E8
L22E0:  POP     HL
        AND     A
        SET     7,(HL)
        JR      NZ,L22E8
        RES     7,(HL)
L22E8:  BIT     0,(HL)
        JR      Z,L2312
        LD      B,$28
        DEC     (HL)
        BIT     6,(HL)
        LD      HL,$4FAA
L22F4:  LD      A,(HL)
        JR      Z,L231C
        CP      $01
        JR      Z,L2323
        DEC     (HL)
L22FC:  PUSH    HL
        CALL    L2A1F
        IN      A,($08)
        POP     HL
        LD      A,(HL)
        CALL    L2A1F
        CALL    L29A9
        AND     A
        JR      Z,L2323
        SET     5,(HL)
L230F:  JP      L239E
L2312:  LD      B,$68
        INC     (HL)
        BIT     7,(HL)
        LD      HL,$4FAB
        JR      L22F4
L231C:  CP      $05
        JR      Z,L2323
        INC     (HL)
        JR      L22FC
L2323:  LD      A,(IX+$0B)
        CP      $30
        JR      C,L239E
        JR      L2333
L232C:  LD      A,(IX+$0B)
        CP      $30
        JR      NC,L239E
L2333:  LD      (IX+$02),$01
        LD      HL,L2E24         ; Pattern Address
        BIT     7,(IX+$01)
        JR      Z,L239E
        SYSTEM  VWRITR           ;  UPI Vector WRITe Relative
        ;
        PUSH    HL
        LD      DE,$0005
        LD      HL,($4F1F)
        ADD     HL,DE
        BIT     7,H
        JR      NZ,L2359
        LD      A,$01
        CP      H
        JR      NC,L235E
L2353:  INC     A
        LD      H,A
        LD      L,$00
        JR      L235E
L2359:  LD      A,$FD
        CP      H
        JR      NC,L2353
L235E:  LD      ($4F1F),HL
        LD      HL,$4F1B
        BIT     7,(HL)
        JR      Z,L2379
        LD      B,$00
        LD      A,$FD
        CP      (HL)
        JR      C,L2380
        INC     A
L2370:  LD      (HL),A
        DEC     HL
        SYSSUK  RANGED           ;  UPI RANGED random number
        DB      $80              ;  ... Cutoff = 128
        ;
        ADD     A,B
        LD      (HL),A
        JR      L2380
L2379:  LD      A,$01
        LD      B,$80
        CP      (HL)
        JR      C,L2370
L2380:  LD      HL,L2F37         ;  Limit Table Address
        SYSTEM  VECT             ;  UPI VECTor move coordinate pair
        ;
        POP     HL
        BIT     3,(IX+$0C)
        JR      Z,L2397
        LD      A,$60
        LD      ($4FD9),A
        RES     7,(IX+$01)
        JR      L239E
L2397:  IN      A,($08)
        SYSTEM  VWRITR           ;  UPI Vector WRITe Relative
        ;
        CALL    L29A9
L239E:  SYSSUK  DECCTS           ;  UPI DECrement CT'S under mask
        DB      $FF              ;  ... Counters = 255
        ;
        POP     IX
        POP     HL
        POP     DE
        POP     BC
        POP     AF
        EI      
        RET     

L23A9:  LD      ($4F8B),A
        EXX     
        ADD     HL,DE
        EXX     
        LD      A,($4FAA)
        BIT     5,(HL)
        JR      NZ,L23B9
        LD      A,($4FAB)
L23B9:  CP      $01
        JR      Z,L23DB
        CP      $04
        JP      Z,L243D
        CP      $03
        JR      Z,L241D
        CP      $02
        JR      Z,L23FF
        INC     HL
        BIT     5,(HL)
        DEC     HL
        JP      NZ,L24D0
        SET     4,(HL)
        JR      L23EA
        CALL    L2AB0
        JP      L2484

L23DB:  INC     HL
        BIT     5,(HL)
        DEC     HL
        JR      NZ,L23F5
        BIT     2,(HL)
        JR      NZ,L23F1
        SET     4,(HL)
        CALL    L29A1
L23EA:  EXX     
        SBC     HL,DE
        EXX     
        JP      L27E3

L23F1:  RES     4,(HL)
        JR      L23EA
L23F5:  LD      BC,$0380
        CALL    L2D9F
        PUSH    DE
        POP     BC
        JR      L2470
L23FF:  BIT     2,(HL)
        JR      Z,L2408
        CALL    L24B4
        JR      L240B
L2408:  CALL    L24DF
L240B:  LD      BC,$0380
        CALL    L2D9F
        EX      DE,HL
        LD      BC,($4F98)
        ADD     HL,BC
        PUSH    HL
        PUSH    BC
        POP     HL
        POP     BC
        JR      L246F
L241D:  BIT     2,(HL)
        JR      Z,L2426
        CALL    L24B4
        JR      L2429
L2426:  CALL    L24DF
L2429:  LD      A,$07
        LD      ($4F8B),A
        LD      BC,$0380
        CALL    L2D9F
        EX      DE,HL
        ADD     HL,HL
        PUSH    HL
        POP     BC
        LD      HL,$0000
        JR      L2470
L243D:  CALL    L24DF
        CALL    L29A1
        LD      BC,$0380
        CALL    L2D9F
        CP      $04
        JR      NC,L2465
        CP      $02
        JR      NC,L2455
        PUSH    DE
        POP     BC
        JR      L2470
L2455:  EX      DE,HL
        LD      BC,($4F98)
        LD      HL,($4F9E)
        ADD     HL,BC
        PUSH    HL
        ADD     HL,BC
        PUSH    HL
        POP     BC
        POP     HL
        JR      L246F

L2465:  EX      DE,HL
        LD      BC,($4F98)
        ADD     HL,BC
        PUSH    BC
        PUSH    HL
        POP     BC
        POP     HL
L246F:  EX      DE,HL
L2470:  PUSH    BC
        EXX     
        BIT     5,(HL)
        EX      AF,AF'
        BIT     1,(HL)
        EXX     
        CALL    NZ,L2AB0
        EX      AF,AF'
        CALL    NZ,L2AAA
        ADD     HL,DE
        POP     DE
        CALL    L2AAA
L2484:  LD      ($4F1A),HL
        LD      ($4F1F),DE
        LD      A,($4F8B)
        SRL     A
        LD      B,(IX+$0B)
        ADD     A,B
        SBC     A,$05
        LD      (IX+$0B),A
        CALL    L2ACE
        LD      A,$80
        LD      ($4F1C),A
        LD      ($4F21),A
        LD      HL,$4F89
        LD      (HL),$00
        INC     HL
        RES     5,(HL)
        RES     4,(HL)
        SET     7,(IX+$01)
        EI      
        RET     

L24B4:  BIT     1,(HL)
        PUSH    AF
        BIT     5,(HL)
        INC     HL
        JR      Z,L24C2
        POP     AF
        RET     Z
        BIT     6,(HL)
        JR      L24C6
L24C2:  POP     AF
        RET     NZ
        BIT     7,(HL)
L24C6:  JR      Z,L24CE
        BIT     5,(HL)
        JR      Z,L24CE
        DEC     HL
        RET     

L24CE:  POP     AF
        DEC     HL
L24D0:  EXX     
        LD      DE,$0000
        LD      A,(IX+$0B)
        ADD     A,$0A
        LD      (IX+$0B),A
        JP      L2484

L24DF:  BIT     5,(HL)
        INC     HL
        JR      Z,L24E8
        BIT     6,(HL)
        JR      L24EA
L24E8:  BIT     7,(HL)
L24EA:  DEC     HL
        RET     NZ
        INC     HL
        BIT     5,(HL)
        JR      NZ,L24CE
        LD      HL,$0000
        PUSH    HL
        POP     DE
        POP     AF
        JP      L2484

;  SENTRY RETURN Code SCT7 Handler
;  Counter-Timer 7 has counted down
L24FA:  DI      
        LD      A,$03
        CALL    $2F57
        LD      HL,$4F8A
        BIT     1,(HL)
        JR      Z,$251F
        RES     1,(HL)
        LD      H,$AA
        LD      C,$09
        LD      DE,$339C
        RST     $28              ;  User ReStarT #5 of 6
        SYSSUK  RECTAN           ;  UPI paint a RECTANgle
        DB      $8F              ;  ... X = 143
        DB      $1D              ;  ... Y = 29
        DB      $0F              ;  ... Width = 15
        DB      $01              ;  ... Height = 1
        DB      $AA              ;  ... Color = 170
        ;
        SYSSUK  RECTAN           ;  UPI paint a RECTANgle
        DB      $91              ;  ... X = 145
        DB      $1C              ;  ... Y = 28
        DB      $0A              ;  ... Width = 10
        DB      $03              ;  ... Height = 3
        DB      $FF              ;  ... Color = 255
        ;
        XOR     A
        LD      HL,($4F1F)
        BIT     7,H
        JR      Z,$252C
        CALL    L2AB0
        SET     2,A
        LD      DE,($4F1A)
        BIT     7,D
        JR      Z,$2539
        CALL    L2AAA
        SET     1,A
        EX      AF,AF'
        LD      A,D
        CP      H
        JR      C,$2548
        JR      NZ,$2544
        LD      A,E
        CP      L
        JR      C,$2548
        EX      AF,AF'
        SET     0,A
        EX      AF,AF'
        EX      AF,AF'
        EXX     
        LD      HL,$4F89
        LD      (HL),A
        PUSH    HL
        CALL    $2ABA
        CALL    $2AC4
        CALL    $2AE1
        LD      D,(IX+$0B)
        LD      E,(IX+$06)
        LD      ($4FA4),DE
        POP     HL
        LD      A,$3C
        CP      D
        JP      C,$27B0
        LD      A,$01
        CALL    $2A08
        LD      A,E
        CP      $06
        JR      C,$257C
        CP      $9A
        JR      NC,$257C
        LD      A,$03
        CP      D
        JR      C,$257E
        SET     7,(HL)
        LD      C,$05
        BIT     3,(IX+$01)
        PUSH    AF
        JR      Z,$2588
        INC     C
        LD      DE,$4F8B
        PUSH    HL
        CALL    $28AC
        POP     HL
        EX      AF,AF'
        POP     AF
        LD      A,B
        JR      NZ,$25BD
        CP      $05
        JR      C,$25BA
        LD      C,$09
        LD      DE,$210A
        PUSH    HL
        CALL    $28AC
        POP     HL
        LD      C,A
        EX      AF,AF'
        LD      A,B
        CP      $04
        JP      Z,$2746
        LD      (HL),C
        JR      C,$25D0
        CP      $07
        JR      C,$25BA
        CP      $09
        JP      C,$26CF
        JR      $25DA
        INC     B
        JP      $277C

L25BD:  CP      $06 
        JR      C,$25BA
        LD      C,$08
        LD      DE,$2174
        PUSH    HL
        CALL    $28AC
        POP     HL
        LD      (HL),A
        EX      AF,AF'
        LD      A,B
        CP      $05
        JP      C,$26D4
        JR      Z,$25B9
        CP      $08
        JP      C,$26CF
        EX      AF,AF'
        RES     5,A
        SET     6,A
        EX      AF,AF'
        LD      A,D
        CP      $04
        JR      NC,$25EE
        EX      AF,AF'
        CALL    $2997
        SET     5,A
        JP      $26CE

L25EE:  CP      $18
        JP      NC,$26A7
        PUSH    HL
        LD      HL,$4F26
        LD      B,(HL)
        INC     HL
        LD      C,(HL)
        INC     HL
        BIT     0,(HL)
        JR      Z,$260F
        LD      A,B
        ADD     A,$03
        SUB     D
        CP      $04
        JR      NC,$260F
        LD      A,C
        ADD     A,$06
        SUB     E
        CP      $07
        JR      C,$2619
        BIT     2,(HL)
        INC     HL
        JR      Z,$25F7
        POP     HL
        LD      A,(HL)
        JP      $26C9

L2619:  RES     0,(HL)     ; ?? This line is executed, I checked
        BIT     3,(HL)
        PUSH    AF
        LD      A,$02
        CALL    $2F57
        PUSH    BC
        POP     DE
        LD      BC,$0306
        XOR     A
        SYSTEM  RECTAN           ;  UPI paint a RECTANgle
        ;
        LD      A,$09
        CALL    $2A08
        CALL    $2A17
        CALL    $2D72
        INC     HL
        INC     HL
        INC     HL
        INC     HL
        POP     AF
        JR      NZ,$2669
        DEC     (HL)
        JR      NZ,$2698
        BIT     3,(IX+$01)
        JR      Z,$264D
        LD      (HL),$18
        DEC     HL
        LD      (HL),$FF
        JR      $2657

L264D:  CALL    $2D42
        LD      (HL),$14
        DEC     HL
        LD      A,(HL)
        OR      $F0
        LD      (HL),A
        DEC     HL
        LD      (HL),$FF
        DEC     HL
        LD      (HL),$FF
        DEC     HL
        INC     (HL)
        LD      A,$90
        CALL    $2A08
        CALL    $2DDB
        JR      $2695

L2669:  INC     HL
        DEC     (HL)
        JR      NZ,$2698
        CALL    $2D42
        DEC     HL
        DEC     HL
        LD      A,(HL)
        OR      $0F
        LD      (HL),A
        INC     HL
        INC     HL
        LD      (HL),$04
        LD      HL,$4FBB
        XOR     A
        OR      (HL)
        JR      NZ,$2690
        INC     (HL)
        INC     HL
        INC     (HL)
        LD      DE,$1F14
        CALL    $2BEC
        LD      DE,$1D87
        CALL    $2BEC
        LD      A,$10
        CALL    $2A08
        CALL    $2D5B
        POP     HL
        BIT     1,(HL)
        JR      NZ,$26A4
        CP      $06
        JR      Z,$26C8
        JP      $25E5

L26A4:  AND     A
        JR      $269F

L26A7:  LD      A,E
        SBC     A,$90
        CP      $0D
        JR      NC,$26C8
        CALL    $2AE1
        LD      A,$0A
        LD      ($4F8D),A
        LD      ($4FD7),A
        LD      ($4FDA),A
        LD      ($4FD8),A
        CALL    $2ABA
        CALL    $2AC4
        JP      $24A4

L26C8:  EX      AF,AF'
        CALL    $298D
        SET     7,A
        EX      AF,AF'
        EX      AF,AF'
        LD      (HL),A
        JP      L27E3

L26D4:  LD      A,D
        CP      $05
        JR      C,$26D1
        CP      $0C
        JR      NC,$26D1
        LD      A,$01
        CALL    $2F57
        LD      A,$14
        CALL    $2A08
        PUSH    HL
        BIT     3,(IX+$01)
        PUSH    AF
        BIT     5,(HL)
        JR      NZ,$26FF
        LD      HL,$2F0F
        POP     AF
        JR      Z,$26FA
        LD      HL,$2F19
        LD      C,$20
        DEC     B
        JR      $270A

L26FF:  LD      HL,$2F0B
        POP     AF
        JR      Z,$2708
        LD      HL,$2F13
        LD      C,$60
        LD      A,B
        DEC     A
        SYSTEM  INDEXW           ;  UPI INDEX Word by A
        ;
        LD      A,D
        LD      HL,$4FB7
        SYSTEM  INDEXB           ;  UPI INDEX Byte by A
        ;
        PUSH    DE
        OR      A
        JR      NZ,$2735
        INC     (HL)
        LD      B,D
        PUSH    BC
        INC     B
        LD      DE,$0006
        LD      HL,$4F8A
        ADD     HL,DE
        DJNZ    $2722
        LD      E,(HL)
        INC     HL
        LD      D,(HL)
        POP     BC
        LD      A,$05
        CP      B
        JR      Z,$2732
        BIT     1,(IX+$01)
        CALL    Z,$2BEC
        POP     DE
        PUSH    DE
        CALL    $2DD0
        POP     DE
        SYSSUK  PAWS             ;  UPI PAUSE
        DB      $0A              ;  ... Interrupts = 10
        ;
        DI      
        CALL    $2DD0
        POP     HL
        JP      $2791

L2746:  LD      A,E
        CP      $0D
        JR      C,$275C
        CP      $0F
        LD      A,C
        LD      B,$05
        JR      NC,$277B
        BIT     6,A
        JR      NZ,$277B
        LD      A,D
        CP      $1F
        JP      C,$25F3
        LD      C,$02
        LD      DE,$2122
        PUSH    HL
        CALL    $28AC
        POP     HL
        LD      C,A
        LD      A,B
        CP      $01
        JP      NZ,$25F3
        LD      B,$05
        LD      A,C
        BIT     5,A
        JR      NZ,$277B
        BIT     4,A
        JR      Z,$277B
        JP      $26C9

L277B:  EX      AF,AF'
        PUSH    HL
        LD      A,B
        LD      HL,$4FB6
        SYSTEM  INDEXB           ;  UPI INDEX Byte by A
        ;
        AND     A
        JR      Z,$278B
        LD      A,$09
        CALL    $2A08
        POP     HL
        LD      A,$00
        CALL    $2F57
        CALL    L2ACE
        EX      AF,AF'
        LD      (HL),A
        EXX     
        CALL    $2BF8
        LD      BC,($4F98)
        ADD     HL,HL
        ADD     HL,BC
        EX      DE,HL
        CALL    $2BF8
        LD      BC,($4F98)
        ADD     HL,HL
        ADD     HL,BC
        CALL    $2A17
        JP      $2815

L27B0:  LD      A,$51
        SUB     E
        CALL    $2896
        LD      A,$7B
        SUB     E
        CALL    $2896
        SET     5,(HL)
        LD      A,$23
        SUB     E
        CALL    $2898
        RES     4,(HL)
        LD      A,$4D
        SUB     E
        CALL    $2898
        LD      A,$4B
        CP      D
        LD      A,(HL)
        JR      C,$2778
        LD      DE,$2076
        LD      C,$03
        PUSH    HL
        CALL    $28AC
        POP     HL
        LD      (HL),A
        LD      A,$03
        CP      B
        JP      C,$27D0
L27E3:  CALL    L2ACE
        BIT     7,(HL)
        EX      AF,AF'
        BIT     6,(HL)
        EXX     
        JR      NZ,$27FC
        CALL    $2BF8
        LD      BC,($4F9E)
        ADD     HL,BC
        EX      DE,HL
        CALL    $2BF8
        JR      $2815

L27FC:  EX      AF,AF'
        JR      Z,$2805
        EX      DE,HL
        CALL    $2BF8
        JR      $2815

L2805:  EXX     
        BIT     3,(HL)
        EX      AF,AF'
        BIT     5,(HL)
        EXX     
        JR      NZ,$2811
        EX      AF,AF'
        JR      NZ,$27FF
        CALL    $2BF8
        EX      DE,HL
        EXX     
        BIT     6,(HL)
        PUSH    AF
        BIT     1,(HL)
        PUSH    AF
        BIT     2,(HL)
        EXX     
        CALL    NZ,L2AAA
        EX      DE,HL
        POP     AF
        CALL    NZ,L2AAA
        POP     AF
        JR      Z,$282B
        EX      DE,HL
        LD      ($4F1F),DE
        LD      ($4F1A),HL
        EXX     
        BIT     6,(HL)
        JR      NZ,$284C
        BIT     5,(HL)
        PUSH    AF
        BIT     4,(HL)
        JR      NZ,$2843
        POP     AF
        JR      Z,$284C
        JR      $2846

L2843:  POP     AF
        JR      NZ,$284C
        CALL    $2ABA
        CALL    $2AC4
        JP      $249C

L284F:  LD      C,A
        LD      A,$44
        BIT     4,(HL)
        JR      NZ,$2858
        LD      A,$54
        SET     4,(HL)
        CP      D
        LD      A,(HL)
        JR      C,$288C
        BIT     5,(HL)
        LD      A,($4FAB)
        JR      Z,$2868
        LD      A,($4FAA)
        CP      $01
        JR      NZ,$287C
        LD      A,$07
        CP      C
        JR      NZ,$287C
        EXX     
        LD      A,H
        EXX     
        CP      $01
        JR      NC,$287F
        SET     6,(HL)
        SET     5,(HL)
        JP      L27E3

L287F:  EXX     
        CALL    $2BF8
        EX      DE,HL
        CALL    $2BF8
        EX      DE,HL
        EXX     
        JP      $23A9

L288C:  BIT     2,A
        JR      Z,$2893
        CALL    $2997
        JP      $2778

L2896:  NEG     
        EX      AF,AF'
        POP     AF
        EX      AF,AF'
        CP      $07
        JR      C,$2889
        CP      $0A
        JR      C,$284F
        CP      $16
        SET     4,(HL)
        JR      C,$287C
        EX      AF,AF'
        PUSH    AF
        RET     

L28AC:  LD      A,(HL)
        EX      AF,AF'
        LD      HL,($4FA4)
        EX      DE,HL
        INC     D
        INC     E
        LD      B,$00
        PUSH    BC
        POP     BC
        INC     B
        EX      AF,AF'
        AND     $C7
        EX      AF,AF'
        LD      A,C
        CP      B
        JR      NZ,$28C3
        EX      AF,AF'
        RET     

L28C3:  PUSH    BC
        INC     HL
        INC     HL
        INC     HL
        LD      C,(HL)
        INC     HL
        INC     HL
        LD      A,(HL)
        INC     HL
        CP      E
        JR      NC,$28DE
        ADD     A,C
        CP      E
        JR      C,$28B7
        EX      AF,AF'
        SET     5,A
        EX      AF,AF'
        SBC     A,$02
        CP      E
        JR      C,$28E8
        JR      $28EC

L28DE:  SUB     C
        DEC     A
        CP      E
        JR      NC,$28B7
        ADD     A,$03
        CP      E
        JR      C,$28EC
        EX      AF,AF'
        SET     3,A
        EX      AF,AF'
        LD      A,(HL)
        CP      D
        JR      NC,$2910
        ADD     A,C
        CP      D
        JR      C,$28B7
        POP     BC
        SBC     A,$02
        CP      D
        JR      NC,$294E
        EX      AF,AF'
        BIT     2,A
        JR      NZ,$2923
        BIT     7,A
        JR      Z,$2908
        CALL    $298D
        JR      $2982
        BIT     1,A
        SET     5,A
        RET     NZ
        RES     5,A
        RET     

L2910:  SUB     C
        CP      D
        JR      NC,$28B7
        POP     BC
        EX      AF,AF'
        SET     4,A
        EX      AF,AF'
        ADD     A,$02
        CP      D
        JR      C,$294E
        EX      AF,AF'
        BIT     2,A
        JR      NZ,$28FF
        BIT     7,A
        JR      NZ,$2946
        BIT     0,A
        JR      NZ,$2908
        EXX     
        PUSH    AF
        XOR     A
        CP      D
        JR      NZ,$2942
        LD      A,$1A
        CP      E
        JR      C,$2942
        LD      E,$34
        POP     AF
        RES     1,A
        BIT     5,A
        JR      NZ,$2941
        SET     1,A
        PUSH    AF
        POP     AF
        EXX     
        JR      $2978

L2946:  BIT     0,A
        JR      Z,$2908
        CALL    $298D
        RET     

L294E:  EX      AF,AF'
        BIT     3,A
        RET     Z
        BIT     1,A
        PUSH    AF
        BIT     5,A
        JR      NZ,$296D
        POP     AF
        JR      Z,$2970
        BIT     7,A
        JR      Z,$2965
        CALL    $2997
        JR      $2982

L2965:  BIT     2,A
        RES     4,A
        RET     NZ
        SET     4,A
        RET     

L296D:  POP     AF
        JR      Z,$295C
        BIT     7,A
        JR      Z,$297C
        BIT     0,A
        JR      NZ,$2965
        CALL    $2997
        RET     

L297C:  BIT     0,A
        JR      Z,$2965
        JR      $294A

L2982:  AND     $07
        EXX     
        ADD     HL,DE
        CALL    $2BF8
        PUSH    HL
        POP     DE
        EXX     
        RET     

L298D:  SET     6,A
        BIT     1,A
        SET     1,A
        RET     Z
        RES     1,A
        RET     

L2997:  SET     6,A
        BIT     2,A
        SET     2,A
        RET     Z
        RES     2,A
        RET     

L29A1:  BIT     5,(HL)
        RES     5,(HL)
        RET     NZ
        SET     5,(HL)
        RET     

L29A9:  IN      A,($08)
        OR      A
        RET     Z
        LD      HL,$4F8A
        SET     4,(HL)
        LD      A,$01
        LD      ($4FDC),A
        RES     7,(IX+$01)
        RET     

;  SENTRY RETURN Code SF1 Handler
;  Flag bit 1 has changed
L29BC:  PUSH    IX
        CALL    $2D36
        LD      HL,$4FBB
        INC     HL
        INC     HL
        DJNZ    $29C4
        PUSH    HL
        LD      D,$57
        LD      HL,$4F18
        BIT     2,(HL)
        RES     2,(HL)
        POP     HL
        PUSH    DE
        LD      BC,$C428
        PUSH    BC
        LD      IX,$020D
        JR      NZ,$29E2
        DI      
        SYSTEM  DISNUM           ;  UPI DISplay NUMber
        ;
        EI      
        PUSH    HL
        CALL    $2D72
        LD      B,(HL)
        POP     HL
        LD      A,($4FB5)
        ADD     A,(HL)
        DAA     
        LD      (HL),A
        LD      A,($4FB6)
        INC     HL
        ADC     A,(HL)
        DAA     
        LD      (HL),A
        DEC     HL
        DJNZ    $29E8
        POP     BC
        POP     DE
        DI      
        SYSTEM  DISNUM           ;  UPI DISplay NUMber
        ;
        EI      
        XOR     A
        LD      ($4FB5),A
        LD      ($4FB6),A
        POP     IX
        RET     

L2A08:  PUSH    HL
        LD      HL,$4FB5
        ADD     A,(HL)
        DAA     
        LD      (HL),A
        LD      A,$00
        INC     HL
        ADC     A,(HL)
        DAA     
        LD      (HL),A
        POP     HL
        RET     

L2A17:  PUSH    HL
        LD      HL,$4FDE
        SET     1,(HL)
        POP     HL
        RET     

L2A1F:  LD      HL,$2EFF         ;  Holds Patten address ??
        SYSTEM  INDEXW           ;  UPI INDEX Word by A
        ;
        EX      DE,HL
        LD      DE,$441C
        LD      A,$CC
        OUT     (XPAND),A        ;  eXPANDer pixel definition port
        LD      A,B
        SYSTEM  WRITR            ;  UPI WRITe RELATIVE
        ;
        LD      DE,$5446
        LD      A,$CC
        OUT     (XPAND),A        ;  eXPANDer pixel definition port
        LD      A,B
        SYSTEM  WRITR            ;  UPI WRITe RELATIVE
        ;
        RET

L2A3A:  PUSH    DE
        PUSH    BC
        DI      
        RST     $28              ;  User ReStarT #5 of 6
        EI      
        POP     BC
        POP     DE
        PUSH    DE
        PUSH    BC
        DI      
        RST     $20              ;  User ReStarT #4 of 6
        EI      
        POP     BC
        POP     DE
        PUSH    DE
        PUSH    BC
        DI      
        RST     $18              ;  User ReStarT #3 of 6
        EI      
        POP     BC
        POP     DE
        PUSH    BC
        DI      
        RST     $10              ;  User ReStarT #2 of 6
        EI      
        POP     BC
        RET     

L2A55:  LD      B,$01
        LD      L,$FF
        LD      A,H
        SYSTEM  RECTAN           ;  UPI paint a RECTANgle
        ;
        DEC     D
        INC     L
        JR      Z,$2A59
        DEC     C
        LD      A,C
        CP      $01
        JR      NZ,$2A59
        RET     

L2A67:  LD      B,$01
        LD      L,$FF
        LD      A,H
        SYSTEM  RECTAN           ;  UPI paint a RECTANgle
        ;
        INC     D
        INC     L
        JR      Z,$2A6B
        DEC     C
        LD      A,C
        CP      $01
        JR      NZ,$2A6B
        RET     

L2A79:  LD      B,$01
        LD      L,$FF
        LD      A,E
        SUB     C
        INC     A
        LD      E,A
        LD      A,H
        SYSTEM  RECTAN           ;  UPI paint a RECTANgle
        ;
        DEC     D
        INC     L
        JR      Z,$2A81
        INC     E
        DEC     C
        LD      A,C
        CP      $01
        JR      NZ,$2A81
        RET     

L2A90:  LD      B,$01
        LD      L,$FF
        LD      A,E
        SUB     C
        INC     A
        LD      E,A
        LD      A,H
        SYSTEM  RECTAN           ;  UPI paint a RECTANgle
        ;
        INC     D
        INC     L
        JR      Z,$2A98
        INC     E
        DEC     C
        LD      A,C
        CP      $01
        JR      NZ,$2A98
        RET     

;  SENTRY RETURN Code SKYD Handler
;  Sentry, KeY is now Down
;
;  Note: There may be multiple ways to enter this routine
;
;  "Coffee Break"
;  Pause Game - One way to enter this routine is to pause the
;               game by pressing 'C' on the 24-key keypad
L2AA7:  SYSTEM  PIZBRK           ;  UPI take a PIZza BReaK
        RET     

L2AAA:  EX      DE,HL
        CALL    L2AB0
        EX      DE,HL
        RET

L2AB0:  PUSH    AF
        LD      A,H
        CPL     
        LD      H,A
        LD      A,L
        CPL     
        LD      L,A
        INC     HL
        POP     AF
        RET  

L2ABA:  LD      HL,($4F1F)
        CALL    L2AB0
        LD      ($4F1F),HL
        RET     

L2AC4:  LD      HL,($4F1A)
        CALL    L2AB0
        LD      ($4F1A),HL
        RET     

L2ACE:  PUSH    HL
        SET     7,(IX+$01)
        LD      (IX+$02),$01
        LD      HL,$2F37
        SYSTEM  VECT             ;  UPI VECTor move coordinate pair
        ;
        RES     7,(IX+$01)
        POP     HL
        PUSH    HL
        LD      HL,$2E24
        SYSTEM  VWRITR           ;  UPI Vector WRITe Relative
        ;
        POP     HL
        RET     

;  SENTRY RETURN Code SCT4 Handler
;  Counter-Timer 4 has counted down
L2AE9:  SYSSUK  FILL             ;  UPI FILL memory with data
        DW      $4FB7            ;  ... Memory Address = 20407
        DW      $0006            ;  ... Byte Count = 6
        DB      $00              ;  ... Data = 0
        ;
        LD      H,$55
        BIT     3,(IX+$01)
        JR      NZ,$2AFF
        LD      C,$04
        LD      DE,($4FA8)
        RST     $08              ;  User ReStarT #1 of 6
        LD      C,$04
        LD      DE,$1D87
        RST     $08              ;  User ReStarT #1 of 6
        BIT     0,(IX+$01)
        JR      NZ,$2B1C
        CALL    $29BC
        CALL    $2C7D
        LD      A,$00
        CALL    $2C1F
        CALL    $2D23
        CALL    $2D42
        LD      HL,$4FCB
        INC     (HL)
        LD      A,($4FF3)
        CP      (HL)
        JR      NC,$2B3F
        LD      (HL),$01
        INC     HL
        CALL    L2BD8
        DEC     (HL)
        CALL    L2BD8
        LD      A,(HL)
        AND     A
        JR      NZ,$2B3F
        CALL    $2BA4
        CALL    $2BA4
        SYSSUK  PAWS             ;  UPI PAUSE
        DB      $60              ;  ... Interrupts = 96
        ;
        SYSTEM  QUIT             ;  UPI QUIT cassette execution
        ;
        CALL    $2D23
        CALL    $2DDB
        CALL    $2D5B
        CALL    $2C1D
        DI      
        LD      HL,$4F8A
        RES     4,(HL)
        SET     1,(HL)
        SET     2,(HL)
        SYSTEM  INTPC            ;  UPI INTerPret with Context create
        ;
        DO      RECTAN           ;  UPI paint a RECTANgle
        DB      $97              ;  ... X = 151
        DB      $3E              ;  ... Y = 62
        DB      $06              ;  ... Width = 6
        DB      $01              ;  ... Height = 1
        DB      $55              ;  ... Color = 85
        ;
        DO      RECTAN           ;  UPI paint a RECTANgle
        DB      $97              ;  ... X = 151
        DB      $49              ;  ... Y = 73
        DB      $06              ;  ... Width = 6
        DB      $01              ;  ... Height = 1
        DB      $55              ;  ... Color = 85
        ;
        DO      RECTAN           ;  UPI paint a RECTANgle
        DB      $8F              ;  ... X = 143
        DB      $1A              ;  ... Y = 26
        DB      $0E              ;  ... Width = 14
        DB      $07              ;  ... Height = 7
        DB      $00              ;  ... Color = 0
        ;
        DO      RECTAN           ;  UPI paint a RECTANgle
        DB      $98              ;  ... X = 152
        DB      $2B              ;  ... Y = 43
        DB      $04              ;  ... Width = 4
        DB      $20              ;  ... Height = 32
        DB      $00              ;  ... Color = 0
        ;
        DO      RECTAN           ;  UPI paint a RECTANgle
        DB      $98              ;  ... X = 152
        DB      $33              ;  ... Y = 51
        DB      $01              ;  ... Width = 1
        DB      $01              ;  ... Height = 1
        DB      $AA              ;  ... Color = 170
        ;
        DO      RECTAN           ;  UPI paint a RECTANgle
        DB      $9B              ;  ... X = 155
        DB      $33              ;  ... Y = 51
        DB      $01              ;  ... Width = 1
        DB      $01              ;  ... Height = 1
        DB      $AA              ;  ... Color = 170
        ;
        DONT    XINTC            ;  UPI eXit INTerpreter with Context
        ;
        LD      HL,$4BDE
        LD      ($4FC5),HL
        LD      HL,$0028
        LD      ($4FC7),HL
        XOR     A
        LD      ($4FC9),A
        LD      HL,$2EF4
        LD      DE,$4F23
        LD      BC,$000D
        BIT     3,(IX+$01)
        LDDR    
        JR      Z,$2BA1
        SET     3,(IX+$01)
        CALL    $2AE1
        LD      B,$05
        LD      A,$00
        PUSH    BC
        CALL    $2F57
        SYSSUK  PAWS             ;  UPI PAUSE
        DB      $0C              ;  ... Interrupts = 12
        ;
        POP     BC
        DJNZ    $2BA6
        LD      A,$01
        CALL    $2F57
        RET     

;  SENTRY RETURN Code SJ1 Handler
;  Joystick 1 for player 2 has changed
L2BB8:  LD      HL,$4F8A
        BIT     2,(HL)
        RET     Z
        RES     2,(HL)
        DI      
        SYSSUK  RECTAN           ;  UPI paint a RECTANgle
        DB      $97              ;  ... X = 151
        DB      $33              ;  ... Y = 51
        DB      $06              ;  ... Width = 6
        DB      $20              ;  ... Height = 32
        DB      $AA              ;  ... Color = 170
        ;
        LD      HL,$4F18
        SET     7,(HL)
        LD      A,($4FCC)
        CP      $05
        JR      NZ,$2BD6
        SET     2,(HL)
        EI      
        RET     

L2BD8:  PUSH    IX
        LD      DE,$3B05
        LD      HL,$4FCC
        LD      BC,$C22C
        LD      IX,$020D
        SYSTEM  DISNUM           ;  UPI DISplay NUMber
        ;
        POP     IX
        RET     

L2BEC:  LD      A,$08
        OUT     ($19),A
        LD      HL,$2E1D
        LD      A,$28
        SYSTEM  WRITR            ;  UPI WRITe RELATIVE
        ;
        RET     

L2BF8:  SRL     H
        RR      L
        LD      ($4F92),HL
        PUSH    HL
        SRL     H
        RR      L
        LD      ($4F98),HL
        SRL     H
        RR      L
        LD      ($4F9E),HL
        POP     HL
        RET     

L2C10:  LD      A,B
        CP      H
        RET     C
        JR      Z,$2C17
        JR      $2C1A
        LD      A,C
        CP      L
        RET     C
        PUSH    BC
        POP     HL
        RET     

;  SENTRY RETURN Code SCT5 Handler
;  Counter-Timer 5 has counted down
L2C1D:  LD      A,$FF
        LD      HL,$4F26
        LD      BC,$0306
        LD      D,(HL)
        INC     HL
        LD      E,(HL)
        INC     HL
        BIT     0,(HL)
        JR      Z,$2C31
        DI      
        SYSTEM  RECTAN           ;  UPI paint a RECTANgle
        ;
        EI      
        BIT     2,(HL)
        RET     NZ
        INC     HL
        JR      $2C22

;  SENTRY RETURN Code SCT2 Handler
;  Counter-Timer 2 has counted down
L2C37:  LD      A,$01
        CALL    $2A08
        LD      HL,$4F8A
        BIT     1,(HL)
        RET     NZ
        DI      
        SYSSUK  RECTAN           ;  UPI paint a RECTANgle
        DB      $91              ;  ... X = 145
        DB      $1A              ;  ... Y = 26
        DB      $0A              ;  ... Width = 10
        DB      $07              ;  ... Height = 7
        DB      $00              ;  ... Color = 0
        ;
        LD      HL,$4F23
        LD      A,($4F8D)
        ADD     A,$03
        CP      $40
        JR      NC,$2C60
        LD      ($4F8D),A
        LD      ($4FD7),A
        BIT     7,(HL)
        JR      Z,$2C6D
        RES     7,(HL)
        SYSSUK  RECTAN           ;  UPI paint a RECTANgle
        DB      $91              ;  ... X = 145
        DB      $1C              ;  ... Y = 28
        DB      $0A              ;  ... Width = 10
        DB      $03              ;  ... Height = 3
        DB      $FF              ;  ... Color = 255
        ;
        LD      A,$04
        JR      $2C78

L2C6D:  SET     7,(HL)
        SYSSUK  RECTAN           ;  UPI paint a RECTANgle
        DB      $91              ;  ... X = 145
        DB      $1A              ;  ... Y = 26
        DB      $0A              ;  ... Width = 10
        DB      $07              ;  ... Height = 7
        DB      $FF              ;  ... Color = 255
        ;
        LD      A,$05
        CALL    $2F57
        EI      
        RET     

;  I THINK that this handles more than one sentry return code ??
;  SENTRY RETURN Code SCT3 and SCT6 Handlers
;  Counter-Timer 3 has counted down
;  Counter-Timer 6 has counted down
L2C7D:  XOR     A
        CALL    $2D0A
L2C81: LD      HL,$4F95
        LD      A,(HL)
        AND     A
        RET     Z
        DEC     (HL)
        LD      A,($4F9B)
        JR      Z,$2CC2
        AND     A
        PUSH    AF
        LD      HL,($4FB1)
        LD      C,(HL)
        INC     HL
        INC     HL
        LD      E,(HL)
        INC     HL
        LD      D,(HL)
        INC     HL
        INC     HL
        INC     HL
        LD      ($4FB1),HL
        LD      H,A
        PUSH    DE
        RST     $08              ;  User ReStarT #1 of 6
        POP     DE
        POP     AF
        JR      Z,$2CBC
        LD      C,$03
        LD      H,$55
        PUSH    DE
        RST     $08              ;  User ReStarT #1 of 6
        LD      HL,($4FB3)
        XOR     A
        OR      (HL)
        INC     HL
        LD      ($4FB3),HL
        POP     DE
        JR      Z,$2CBC
        DI      
        CALL    $2BEC
        EI      
        LD      A,$01
        LD      ($4FDB),A
        RET     

L2CC2:  AND     A
        RET     NZ

L2CC4:  LD      HL,$4FB7
        LD      ($4FB3),HL
        CALL    $2CBC
        LD      A,$AA
        CALL    $2D0A
        RES     1,(HL)
        LD      HL,$4F90
        LD      DE,$0005
        LD      B,$64
        SYSSUK  RANGED           ;  UPI RANGED random number
        DB      $10              ;  ... Cutoff = 16
        ;
        ADD     A,B
        PUSH    AF
        LD      (HL),A
        INC     HL
        LD      B,$1C
        LD      (HL),B
        ADD     HL,DE
        SBC     A,$2C
        LD      (HL),A
        INC     HL
        LD      (HL),B
        ADD     HL,DE
        ADD     A,$16
        LD      (HL),A
        INC     HL
        LD      A,$12
        ADD     A,B
        LD      (HL),A
        ADD     HL,DE
        INC     HL
        LD      (HL),A
        DEC     HL
        POP     AF
        SBC     A,$42
        LD      (HL),A
        BIT     3,(IX+$01)
        RET     Z
        
L2D02:  ADD     HL,DE
        INC     HL
        SBC     A,$16
        LD      (HL),A
        INC     HL
        LD      (HL),B
        RET     
        
L2D0A:  LD      ($4F9B),A
        LD      HL,$4F8E
        LD      ($4FB1),HL
        LD      HL,$4F18
        BIT     3,(HL)
        LD      A,$05
        JR      Z,$2D1D
        INC     A
        LD      ($4F95),A
        SET     1,(HL)
        RET     
        
L2D23:  CALL    $2D36
        LD      D,$4F
        LD      A,$08
        OUT     ($19),A
        LD      HL,$2E11
        LD      A,$28
        DI      
        SYSTEM  WRITP            ;  UPI WRITe with Pattern size lookup
        ;
        EI      
        RET     
        
L2D36:  LD      A,($4FCB)
        LD      B,A
        LD      HL,$2EF4
        SYSTEM  INDEXB           ;  UPI INDEX Byte by A
        ;
        INC     A
        LD      E,A
        RET     
        
L2D42:  PUSH    HL
        CALL    $2D72
        EX      DE,HL
        INC     DE
        LD      HL,$4F28
        CALL    $2D80
        LD      (DE),A
        INC     DE
        CALL    $2D80
        LD      (DE),A
        INC     DE
        CALL    $2D80
        LD      (DE),A
        POP     HL
        RET     
        
L2D5B:  CALL    $2D72
        EX      DE,HL
        INC     DE
        LD      A,(DE)
        LD      HL,$4F28
        CALL    $2D8F
        INC     DE
        LD      A,(DE)
        CALL    $2D8F
        INC     DE
        LD      A,(DE)
        CALL    $2D8F
        RET     
        
L2D72:  LD      A,($4FCB)
        LD      B,A
        LD      HL,$4F6B
        LD      DE,$0006
        ADD     HL,DE
        DJNZ    $2D7C
        RET     
        
L2D80:  LD      B,$08
        XOR     A
        BIT     0,(HL)
        JR      Z,$2D88
        SCF     
        RLA     
        INC     HL
        INC     HL
        INC     HL
        DJNZ    $2D83
        RET     
        
L2D8F:  LD      B,$08
        RLA     
        RES     0,(HL)
        JR      NC,$2D98
        SET     0,(HL)
        INC     HL
        INC     HL
        INC     HL
        DJNZ    $2D91
        RRA     
        RET     
        
L2D9F:  PUSH    BC
        EXX     
        EX      DE,HL
        CALL    $2BF8
        LD      HL,($4F98)
        POP     BC
        EX      DE,HL
        CALL    $2C10
        CALL    $2BF8
        EX      DE,HL
        LD      A,($4F8B)
        LD      BC,$0080
        CP      $04
        RET     NC
        
L2DBA:  ADD     HL,BC
        RET     

L2DBC:  LD      A,$0C
        OUT     ($19),A
        LD      D,$04
        LD      E,(HL)
        INC     HL
        INC     HL
        PUSH    HL
        LD      A,C              ;  ... Magic Register
        LD      HL,$2DF8         ;  ... Pattern Address -
        SYSTEM  WRITP            ;  UPI WRITe with Pattern size lookup
        ;
        POP     HL
        DJNZ    L2DBC
        RET     

L2DD0:  LD      HL,$2E01
        LD      D,$04
        LD      A,C
        DI      
        SYSTEM  WRITP            ;  UPI WRITe with Pattern size lookup
        ;
        EI      
        RET     

L2DDB:  CALL    $2D72
        PUSH    IX
        LD      BC,$C102
        LD      IX,$020D
        LD      DE,$456C
        DI      
        SYSTEM  DISNUM           ;  UPI DISplay NUMber
        ;
        POP     IX
        SYSSUK  WRITP            ;  UPI WRITe with Pattern size lookup
        DB      $71              ;  ... X = 113
        DB      $46              ;  ... Y = 70
        DB      $20              ;  ... Magic = 32
        DW      $2E18            ;  ... Pattern Address = 11800
        ;
        EI      
        RET     

;  Pattern Address for WRITP
L2DF8:  DB      $01, $07         ; X, Y Pattern Size
        DB      $78
        DB      $1C
        DB      $0E
        DB      $07
        DB      $03
        DB      $01
        DB      $01

        DB      $02
        DB      $07
        DB      $85
        DB      $00
        DB      $29
        DB      $40
        DB      $0A
        DB      $50
        DB      $02
        DB      $94
        DB      $00
        DB      $A5
        DB      $00
        DB      $29
        DB      $00
        DB      $08
        DB      $01
        DB      $05
        DB      $10
        DB      $08
        DB      $FC
        DB      $08
        DB      $10
        DB      $01
        DB      $03
        DB      $88
        DB      $20
        DB      $88
        DB      $FE
        DB      $FF
        DB      $01
        DB      $05
        DB      $20
        DB      $70
        DB      $20

;  Pattern ??
L2E24:  DB      $00,$00          ; X,Y Displacement
        DB      $01,$02          ; X,Y Size
        DB      $F0
        DB      $F0

;  Pattern ??
L2E2A:  DB      $00,$FB          ; X,Y Displacement
        DB      $01,$07          ; X,Y Size
        DB      $06
        DB      $0E
        DB      $1C
        DB      $38
        DB      $70
        DB      $E0
        DB      $C0

;  Pattern ??
L2E35:  DB      $00,$FD          ; X,Y Displacement
        DB      $01,$05          ; X,Y Size
        DB      $07
        DB      $1F
        DB      $7E
        DB      $F8
        DB      $E0

;  Pattern ??
L2E3E:  DB      $00,$00          ; X,Y Displacement
        DB      $01,$02          ; X,Y Size
        DB      $FF
        DB      $FF

;  Pattern ??
L2E44:  DB      $00,$00          ; X,Y Displacement
        DB      $01,$05          ; X,Y Size
        DB      $E0
        DB      $F8
        DB      $7E
        DB      $1F
        DB      $07

;  Pattern address for 
L2E4D:  DB      $00, $00         ; X,Y Displacement
        DB      $01, $07         ; X, Y Size
        DB      $C0              ; 11......
        DB      $E0              ; 111.....
        DB      $70              ; .111....
        DB      $38              ; ..111...
        DB      $1C              ; ...111..
        DB      $0E              ; ....111.
        DB      $06              ; .....11.

L2E58:  DB      $05
        DB      $16
        DB      $00
        DB      $05
        DB      $1E
        DB      $00
        DB      $05
        DB      $26
        DB      $00
        DB      $05
        DB      $2E
        DB      $00
        DB      $05
        DB      $5C
        DB      $00
        DB      $05
        DB      $64
        DB      $00
        DB      $05
        DB      $6C
        DB      $00
        DB      $05
        DB      $74
        DB      $00
        DB      $05
        DB      $7C
        DB      $00
        DB      $05
        DB      $84
        DB      $02
        DB      $09
        DB      $16
        DB      $00
        DB      $09
        DB      $1E
        DB      $00
        DB      $09
        DB      $26
        DB      $00
        DB      $09
        DB      $2E
        DB      $00
        DB      $09
        DB      $5C
        DB      $00
        DB      $09
        DB      $64
        DB      $00
        DB      $09
        DB      $6C
        DB      $00
        DB      $09
        DB      $74
        DB      $00
        DB      $09
        DB      $7C
        DB      $00
        DB      $09
        DB      $84
        DB      $00
        DB      $11
        DB      $05
        DB      $08
        DB      $15
        DB      $05
        DB      $08
        DB      $19
        DB      $05
        DB      $08
        DB      $1D
        DB      $05
        DB      $0C
        DB      $04
        DB      $19
        DB      $00
        DB      $09
        DB      $15
        DB      $00
        DB      $09
        DB      $1D
        DB      $00
        DB      $0E
        DB      $15
        DB      $00
        DB      $0E
        DB      $1D
        DB      $00
        DB      $04
        DB      $4D
        DB      $00
        DB      $09
        DB      $49
        DB      $00
        DB      $09
        DB      $51
        DB      $00
        DB      $0E
        DB      $45
        DB      $00
        DB      $0E
        DB      $4D
        DB      $00
        DB      $0E
        DB      $55
        DB      $00
        DB      $04
        DB      $81
        DB      $00
        DB      $09
        DB      $7D
        DB      $00
        DB      $09
        DB      $85
        DB      $00
        DB      $0E
        DB      $7D
        DB      $00
        DB      $0E
        DB      $85
        DB      $00
        DB      $13
        DB      $0A
        DB      $00
        DB      $11
        DB      $29
        DB      $00
        DB      $11
        DB      $31
        DB      $00
        DB      $11
        DB      $39
        DB      $00
        DB      $11
        DB      $62
        DB      $00
        DB      $11
        DB      $6A
        DB      $00
        DB      $11
        DB      $72
        DB      $00
        DB      $13
        DB      $90
        DB      $04
        DB      $20
        DB      $00
        DB      $00
        DB      $00
        DB      $00
        DB      $00
        DB      $99
        DB      $01
        DB      $00
        DB      $FD
        DB      $00
        DB      $31
        DB      $01
        DB      $2C
        DB      $5F
        DB      $03
        DB      $88

;  Color Table
L2EF9:  DB      $F0             ; color 3 Left = Blue 
        DB      $5A             ; color 2 Left = Red
        DB      $86             ; color 1 Left = Green-ish Yellow 
        DB      $07             ; color 0 Left = White 
 
;  Color Table
L2EFD:  DB      $FF             ; color 3 Left = Very Light Blue
        DB      $86             ; color 2 Left = Green-ish Yellow
        DB      $63             ; color 1 Left = Reddish Orange
        DB      $00             ; color 0 Left = Black
        
; List of Patterns for WRITR ??
L2F01:  DW      L2E2A
        DW      L2E35
        DW      L2E3E
        DW      L2E44
        DW      L2E4D

L2F0B:  DB      $94
        DB      $03
        DB      $4A
        DB      $02
        DB      $3B
        DB      $01
        DB      $90
        DB      $00
        DB      $90
        DB      $04
        DB      $61
        DB      $01
        DB      $28
        DB      $00
        DB      $28
        DB      $03
        DB      $61
        DB      $02
        DB      $90
        DB      $05

L2F1F:  DB      "BALLY PIN 1",$00
L2F2B:  DB      "BALLY PIN 2",$00

; VECT - Limit Table [for ball ??]
L2F37:  DB      $00        ; X Lower Limit
        DB      $9E        ; X Upper Limit
        DB      $00        ; Y Lower Limit
        DB      $5C        ; Y Upper Limit

;  DOIT table
L2F3B:  RC      SCT2, L2C37, $00    ; Sentry, Counter-Timer 2 has counted down
        RC      SCT3, L2C7D, $00    ; Sentry, Counter-Timer 3 has counted down
        RC      SCT4, L2AE9, $00    ; Sentry, Counter-Timer 4 has counted down
        RC      SCT5, L2C1D, $00    ; Sentry, Counter-Timer 5 has counted down
        RC      SCT6, L2C81, $00    ; Sentry, Counter-Timer 6 has counted down
        RC      SCT7, L24FA, $00    ; Sentry, Counter-Timer 7 has counted down
        RC      SF1,  L29BC, $00    ; Sentry, Flag bit 1 has changed
        RC      SJ1,  L2BB8, $00    ; Sentry, Joystick 1 for player 2 has changed
        RC      SKYD, L2AA7, ENDx   ; Sentry, KeY is now Down
       
L2F57:  PUSH    HL
        PUSH    DE
        PUSH    IX
        LD      HL,$2F6E
        SYSTEM  INDEXW           ;  UPI INDEX Word by A
        ;
        EX      DE,HL
        LD      A,$0C
        LD      IX,$4F17
        SYSTEM  BMUSIC           ;  UPI Begin playing MUSIC
        ;
        POP     IX
        POP     DE
        POP     HL
        RET     

; Music Score Table ??
L2F6E:  DW      L2F7A
        DW      L2FE6
        DW      L2FA3
        DW      L2FB8
        DW      L2FC2
        DW      L2FCA

; Music Score - ??
L2F7A:  MASTER  $28
        VOLUME  $00,$0F          ;  VA = 0, VB = 0, VC= 15, NM = 0
        LEGSTA                   ;  Toggle to LEGato from STAccato
        NOTE1   $01, G1
        NOTE1   $01,AS1
        NOTE1   $01, C2
        NOTE1   $01,DS2
        NOTE1   $01, F2
        NOTE1   $01,GS2
        NOTE1   $01,AS2
        NOTE1   $03, C3
        NOTE1   $01,AS2
        NOTE1   $01,GS2
        NOTE1   $01,FS2
        NOTE1   $01, E2
        NOTE1   $01, D2
        NOTE1   $01, C2
        NOTE1   $01,AS1
        NOTE1   $02, A1
        NOTE1   $03, G1
        QUIET   

; Music Score - ??
L2FA3:  MASTER  $20
        VOLUME  $00,$0F          ;  VA = 0, VB = 0, VC= 15, NM = 0
        LEGSTA                   ;  Toggle to LEGato from STAccato
        NOTE1   $02, C2
        NOTE1   $02, D2
        NOTE1   $02, E2
        NOTE1   $01,FS2
        NOTE1   $01,GS2
        NOTE1   $01,AS2
        NOTE1   $01, C3
        QUIET   

; Music Score - ??
L2FB8:  MASTER  $28
        VOLUME  $00,$08          ;  VA = 0, VB = 0, VC= 8, NM = 0
        OUTPUT  $04,$48          ;  set VIBRA = 72
        NOTE1   $08, G2
        QUIET   

; Music Score - ??
L2FC2:  MASTER  $45
        VOLUME  $00,$06          ;  VA = 0, VB = 0, VC= 6, NM = 0
        NOTE1   $04, A2
        QUIET   

; Music Score - ??
L2FCA:  MASTER  $45
        VOLUME  $00,$06          ;  VA = 0, VB = 0, VC= 6, NM = 0
        NOTE1   $04, C2
        QUIET   

; ?? I'm not sure what these next few bytes are.  They look like music data
;    but I can't find a way to read them. ??        
L2FD2:  DB      $DC
        DB      $DB
        DB      $07
        DB      $A8
        DB      $07
        DB      $A8
        DB      $0E
        DB      $7E
        DB      $0E
        DB      $70
        DB      $0E
        DB      $64
        DB      $C9
        DB      $07
        DB      $A8
        DB      $07
        DB      $A8
        DB      $0E
        DB      $A8
        DB      $C9

; Music Score - ??
L2FE6:  MASTER  $46
        LEGSTA                   ;  Toggle to LEGato from STAccato
        VOLUME  $00,$0F          ;  VA = 0, VB = 0, VC= 15, NM = 0
        PUSHN   $04              ;  PUSH Number 4
L2FED:  NOTE1   $02, G1
        NOTE1   $01, A1
        NOTE1   $01, B1
        NOTE1   $02,CS2
        NOTE1   $03,DS2
        NOTE1   $02, F2
        DSJNZ   L2FED
        ;
        QUIET

        DB      $00
        DB      $00
        DB      $FF

END

-------------------------------------------------------------------
Bally Pin Game Instructions and Review

Note: This will not be printed in the assembly listing, as it
      appears after the source code's END statement.
-------------------------------------------------------------------

Bally Pin - Instruction (Astrocade Version)
-------------------------------------------

"It has everything except a slot to collect your quarters! Thumper 
bumpers! Kicker targets! Drop targets! Realistic flipper action! 
They'll even catch the ball and roll it back and forth to give you 
the direction you want! Two different playing fields create the 
impression of having two pinball machines in one. Up to 4 players."

VIDEOCADE #3005 BALLY PIN

Programmed by Bob Ogdon
Audio by Scot Norris

BALLY PIN 1 (1 to 4 Players)

     Enjoy hours of fun with your Arcade pinball machine. Score 
points by bouncing the ball off various targets, bumpers and 
spinners. Win with the highest score after five balls are played.     

STARTING THE GAME

     Choose Bally Pin #1 by pressing 1 on the keypad or by using 
remote game selection (pull the trigger on hand control #1, turn the 
knob until 1 appears on the screen, then pull the trigger again).

     Enter the number of players (1-4).

PLAYING THE GAME

     The hand control functions for Bally Pin #1 are:

     Hand Control      #1               #2

     Trigger      Left Flippers   Right Flippers
     Knob         No function     No function
     Joystick     No function     Controls Ball Shooter

     To start the game, release the ball into the playing field with 
the joystick of hand control #2. The ball shooter, located on the 
right side of the screen, moves the ball up and down before it is 
served. If the ball is released when it is high in the shooter, 
there will be a slow serve. If the ball is released low in the 
shooter, the serve will be fast.

     Each player uses both hand controls to play the ball. When his 
turn ends, the current player passes both hand controls to the next 
player, and the game continues until each person has played five 
balls. The remaining number of balls is shown in the box to the 
lower left of the playing field. The current player is indicated by 
the arrow pointing to his number.

     After a ball has been released, a spinner target appears above 
the ball shooter. When the spinner target is hit, it randomly moves 
the four middle bumpers and resets the drop targets. When the four 
upper kicker targets are hit, they light the four corresponding 
middle bumpers which then have a (+) at their centers.

     As the ball hits the various objects, sounds are heard as it 
rebounds at different speeds and angles. The flippers are used to 
keep the ball in the playing field. The ball reacts as a "real" ball 
would when struck by a flipper. When the end or corner of the 
flipper strikes the ball, it results in steeper angles and faster 
action than if the middle of the flipper strikes the ball.

     The players' scores are located in boxes at the base of the 
playing field. After each person has used up all five balls, the 
player with the highest score is the winner.

SCORING

     Control where the ball is sent through skillful use of the 
shooter and flippers. If a flipper is used too early or too late, 
there will be very little, if any, control of the ball. By keeping 
the ball in the playing field as long as possible and aiming at the 
highest scoring targets, you will soon achieve a record number of 
points. The values of each object are:

     Wall and Ceiling above Flippers...   10 points
     Drop Targets .....................  100 points
     Upper Kicker Targets .............  150 points
     Bumpers (unlit) ..................   10 points
     Bumpers (lit) ....................  100 points
     Spinner (per rotation)............   10 points

     In addition, a 200 point bonus is awarded when the four drop 
targets in the chute on the left are knocked out.

     A 1,000 point bonus is awarded and all point values are doubled 
when the 20 drop targets on the top are knocked out.

     When a doubled or tripled scoring situation is achieved, a 2X 
or 3X will appear on the left side of the inside right flipper.

PLAYING AGAIN

     To play Bally Pin again, press the RESET button, and follow the 
instructions for starting the game.

BALLY PIN 2 (1 to 4 players)

     The object and the playing of Bally Pin #2 Is the same as #1, 
except that there is a different playing field.

STARTING THE GAME

Choose Bally Pin #2 by pressing 2 on the keypad or by using remote 
game selection (pull the trigger on hand control #1, turn the knob 
until 2 appears on the screen, then pull the trigger again).

Enter the number of players (1-4).

PLAYING THE GAME

     There are six upper kicker targets which, when hit, light the 
corresponding bumpers. The bumpers (when lit) will have a (+) at 
their centers.

     After a spinner has been hit, the five bumpers at the left are 
randomly moved and the drop targets are reset.

     SCORING

     Wall and Ceiling above Flippers...   10 points
     Drop Targets .....................  100 points
     Upper Kicker Targets .............  150 points
     Bumpers (unlit) ..................   10 points
     Bumpers (lit) ....................  100 points
     Spinner (per rotation)............   10 points

     A 1,000 point bonus is awarded and all point values are doubled 
when the 24 drop targets on the top are knocked out.

     When a doubled or tripled scoring situation is achieved, a 2X 
or 3X will appear on the left side of the inside right flipper.

PLAYING AGAIN

     To play Bally Pin again, press the RESET button, and follow the 
instructions for starting the game.


Bally Pin Game Review
---------------------
                                        
Bill Kunkel's and Arnie Katz's "Arcade Alley" department in Video 
magazine has a column called Astrovision's Rising Star on page 42 of 
the the May 1982 issue. There is a short review of Bally Pin in the 
article. I've extracted it here:

"Bally Pin (Astrovision/3005) waited in limbo for some time before 
seeing the light of day. Its year or more of obscurity proved 
undeserved. This is absolutely the best video-game pinball 
simulation ever offered for any programmable home system. It clearly 
shows Bally's expertise in the pinball area. It had to be first 
class all the way to maintain Bally's reputation, and is.

"Designer Bob Ogdon responded to the challenge with a dual-playfield 
masterpiece that captures all the sights, sounds, and spirit of 
genuine flipper-game play. Using a pair of the Professional Arcade's 
excellent pistol-grip command units, players can effectively control 
left- and right-side flippers individually. Both of the electronic 
tables use the same flipper arrangement. Each has a pair of bats at 
the center of the bottom of the screen, with single flippers 
guarding two extra drains located along the lower edge of the field 
to the left and right of the central pair.

"The trimmings should be familiar to those who occasionally forsake 
the delights of Pac-Man and Defender for coin-op pinball machines. 
The highlights include back bumpers, thumper bumpers, drop targets, 
a spinner, and virtually everything else you'd expect except a 
flashing back-plate.

"Orchestrating ball movement is perhaps the hardest part of pinball 
to translate to the video screen. Bill Budge, who created the best-
selling Apple II program Raster Blaster, worked out the ball 
dynamics mathematically, determining the effect of gravity and other 
physical laws on the trajectory of a wildly bouncing metal sphere. 
Bob Ogdon has done virtually as well here, infusing his creation 
with a feeling of realism that is generally absent in video pin 
contests.

"Field number one in Bally Pin is a colorful explosion of white, 
red, and yellow. The second table is equally vibrant, though many 
will find its more soothing dark field easier on the eyes. Drop 
targets and bumpers are placed a little differently in each version, 
though they are the same overall.

"Standard pinball strategy definitely applies, so gaining optimal 
control over flipper movement is the top priority. The flippers can 
be held in the up position indefinitely, permitting the arcader to 
trap the ball for a few seconds while deciding which part of the 
field should be its next destination. Having the player hold one 
controller in each hand is this game's most significant innovation. 
It provides a sensation unlike anything else in video-gaming while 
faithfully reproducing the necessary pinball ambience."
